/*
 * Decompiled with CFR 0.152.
 */
package com.nimu.rptalkmod;

import com.nimu.rptalkmod.TypingStateManager;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.game.ServerboundCustomPayloadPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="rptalkmod", value={Dist.CLIENT})
public class ClientTypingListener {
    private static final ResourceLocation REGISTER = new ResourceLocation("minecraft", "register");

    @SubscribeEvent
    public static void onClientJoin(ClientPlayerNetworkEvent.LoggedInEvent event) {
        Connection connection = event.getConnection();
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.writeBytes("rptalk:indicator".getBytes(StandardCharsets.UTF_8));
        buf.writeByte(0);
        connection.m_129512_((Packet)new ServerboundCustomPayloadPacket(REGISTER, buf));
        connection.channel().pipeline().addBefore("packet_handler", "typing_listener", (ChannelHandler)new ChannelDuplexHandler(){

            public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                ClientboundCustomPayloadPacket packet;
                if (msg instanceof ClientboundCustomPayloadPacket && (packet = (ClientboundCustomPayloadPacket)msg).m_132042_().toString().equals("rptalk:indicator")) {
                    byte[] bytes = new byte[packet.m_132045_().readableBytes()];
                    packet.m_132045_().readBytes(bytes);
                    String msgStr = new String(bytes, StandardCharsets.UTF_8);
                    String[] parts = msgStr.split(";");
                    if (parts.length == 3 && parts[0].equals("update")) {
                        UUID uuid = UUID.fromString(parts[1]);
                        boolean typing = Boolean.parseBoolean(parts[2]);
                        TypingStateManager.setTyping(uuid, typing);
                    }
                    return;
                }
                super.channelRead(ctx, msg);
            }
        });
    }
}

